
 
; (Sentry Alert receiver)


	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_ON & _BODEN_ON & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
	

;  RAM. Covers bank 0 & bank 1

W_TMP			equ	H'20'	; storage of w before interrupt
STATUS_TMP		equ	H'21'	; status storage before interrupt

FLAG1			equ	H'23'	; interrupt flag with timer 0
TIMEOUT			equ	H'24'	; timeout counter
FQ_FLAG			equ	H'25'	; frequency flag
TRANS_COUNT		equ	H'26'	; transmission counter	
STORE1			equ	H'27'	; delay counter	
STORE2			equ	H'28'	; delay counter
RECEIVE0		equ	H'29'	; received data
RECEIVE1		equ	H'2A'	; received data
TIMER1L_WK		equ	H'2B'	; timer 1 ls byte working register
TIMER1H_WK		equ	H'2C'	; timer 1 ms byte working register
TIMER1L_VAL		equ	H'2D'	; timer 1 ls byte working register
TIMER1H_VAL		equ	H'2E'	; timer 1 ms byte working register
TIMER1L_2		equ	H'2F'	; timer 1 /2 ls byte working register
TIMER1H_2		equ	H'30'	; timer 1 /2 ms byte working register
FLAG			equ	H'31'   ; interrupt flag with timer 1
COUNT_BITS		equ	H'32'	; data count bits
ENCODE			equ	H'33'	; encode value
RECEIVEX		equ	H'34'	; stop bits
DURATION		equ	H'35'	; ms counter for duration of alert
TIME0_CNT		equ	H'36'	; timeout of timer 0
TEMP			equ	H'37'	; temporary use
CYCLE			equ	H'38'	; tone generator cycle
SET1			equ	H'39'	; frequency setting value
BIPS_No			equ	H'3A'	; number of bips
DEL_EXTN		equ	H'3B'	; delay extension
LED_ON			equ	H'3C'	; LED on counter
MULTIPLY		equ	H'3D'	; LED on delay multiplier
LENGTH			equ	H'3E'	; non-directional detection sound length
FLASH			equ	H'3F'	; LED flashing (alternating flag)

MODE			equ	H'40'	; operating mode, drive piezo and LEDs or the on/off relays
EXTN			equ	H'41'	; extension delay
STORE1_STO		equ	H'42'	; store of STORE1 value

; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN		; 
	org     4			; interrupt vector
	goto	INTERRUPT


; ***********************************************************************

INTERRUPT
; Interrupt
; start interrupt by saving w and status registers  
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
; page and banks	
	bcf		STATUS,RP0	; select memory bank 
	bcf		STATUS,RP1	; select memory bank 0

; Interrupt source
	btfss	PIR1,TMR1IF	; if timer 1 flag
	goto	TIME_0		; is it timer 0 
; preload timer for timer 1 interrupt rate
	bcf		T1CON,0		; timer 1 off	
	movf	TIMER1H_VAL,w
	addwf	TMR1H,f
	movf	TIMER1L_VAL,w
	addwf	TMR1L,f
	btfsc	STATUS,C
	incf	TMR1H,f		; increase ms byte if ls addition has carry
	bsf		T1CON,0		; timer 1 on
	bcf		PIR1,TMR1IF	; clear timer 1 overflow
	bsf		FLAG,0		; set flag bit to indicate an interrupt has occurred for data reception

TIME_0 ; 1.024ms
	btfss	INTCON,T0IF
	goto	RECLAIM
	bcf		INTCON,T0IF
	bsf		FLAG1,0		; set flag bit to indicate an interrupt has occurred for data reception
	movf	TIME0_CNT,w	; decrease if not 0
	btfss	STATUS,Z
	decf	TIME0_CNT,f

; decrease LED on timer

 	decfsz	MULTIPLY,f
	goto	RECLAIM		; delay multiplier (256)
	movf	LED_ON,w
	btfss	STATUS,Z	; decrease when not zero
	goto	REDUCE_LED_COUNT
	bcf		GPIO,0		; EXIT LED off 
	bcf		GPIO,1		; ENTRY LED off
	clrf	FLASH
	goto	RECLAIM
 
REDUCE_LED_COUNT
	decf	LED_ON,f

; if FLASH,7 set then flash LEDs alternately
	btfss	FLASH,7
	goto	RECLAIM
	
	incf	FLASH,f
	bsf		FLASH,7		; keep bit 7 set
	btfss	FLASH,2
	goto	FLASH1
	bcf		GPIO,0
	bsf		GPIO,1
	goto	RECLAIM
FLASH1
	bsf		GPIO,0
	bcf		GPIO,1	

; end of interrupt restore status and w 
RECLAIM
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;******************************************************************************************* 

MAIN

	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	clrf	GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; pullups (GP1 pullup)
	movwf	WPU
	movlw	B'00111110'	; outputs/inputs set (initially, GP1 an input)
	movwf	TRISIO		; port data direction register
	movlw	B'00000001'	; settings timer0 /4
	movwf	OPTION_REG
; calibrate internal oscillator
	call	H'3FF'		; retlw 'xx'. xx is the osccal value
	movwf	OSCCAL
; analog inputs, A/D
	movlw	B'01011100'	; AN2 & AN3 analog input 
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00001100'	; channel 3 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

; initial conditions
	movlw	B'00000000'	; port low
	movwf	GPIO	

 	movlw	H'FB'		; preload timer 1
	movwf	TIMER1H_VAL
	movwf	TMR1H
	movlw	H'FF'
	movwf	TIMER1L_VAL
	movwf	TMR1L
	bcf		T1CON,5		; /1 prescaler
	bcf		T1CON,4
	bsf		T1CON,0		; timer 1 on	
	clrf	FLASH
	call	DELAYms		; add small delay


; Check Mode. MODE=0 Piezo and LEDs, if MODE,7 set; Relays 
; test if GP1 goes high with GP0 (piezo is connected if so as the input (GP1) will follow GP0 due to its capacitance)

	bsf		GPIO,0
	nop
	btfss	GPIO,1
	goto	RELAY_MODE
; Piezo connected
	clrf	MODE
	goto	PIN_CHANGE
RELAY_MODE
	clrf	GPIO		; outputs low
	bsf		MODE,7
; make GP1 an output
PIN_CHANGE
; change GP1 to an output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00111100'	; outputs/inputs set  (GP1 an output)
	movwf	TRISIO		; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
	clrf	GPIO

; allow interrupts
ALL_INTERRUPTS
	bsf		STATUS,RP0	; select memory bank 1		
	bsf		PIE1,TMR1IE	; timer 1 overflow interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PIR1,TMR1IF	; timer 1 interrupt flag
	bsf		INTCON,T0IE	; timer 0 enable
	bcf		INTCON,T0IF	; timer 0 interrupt flag
	bsf		INTCON,PEIE	; enable periperal interrupts 	 
	bsf 	INTCON,GIE	; set global interrupt enable 

; check for a high at GPIO,5
INPUT_SIG
	bsf 	INTCON,GIE	; set global interrupt enable 
	btfss	GPIO,5		; when high begin to read data
	goto	INPUT_SIG
	clrf	TMR0		; clear timer
	nop
	nop
	nop
	clrf	FLAG1		; 
	movlw	D'10'		; transmission counter
	movwf	TRANS_COUNT
TRANS_LOOP
	btfss	FLAG1,0		; count flags (set in interrupt) for a 10ms transmission from transmitter 
	goto	TRANS_LOOP
	btfss	GPIO,5		; check if still high
	goto	INPUT_SIG	; not high so out
	decfsz	TRANS_COUNT,f; count
	goto	QUIETING_LOOP
	goto	LOCK_START
QUIETING_LOOP
	clrf	FLAG1
	goto	TRANS_LOOP
	
LOCK_START
; use start bits to lock the transmission frequency

	bsf		STATUS,RP0	; select memory bank 1		
	bcf		PIE1,TMR1IE	; stop timer 1 overflow interrupt
	bcf		STATUS,RP0	; select memory bank 0

	bcf		T1CON,0		; stop timer 1
	clrf	TMR1L		; clear timer 1
	clrf	TMR1H
	clrf	FLAG		; interrupt occurred flag
	bcf		PIR1,TMR1IF	; clear interrupt flag
	movlw	D'64'
	movwf	TIME0_CNT	; timer counter
	movlw	D'24'
	movwf	COUNT_BITS	; number of bits of data
	
; count with timer 1 for GPIO,5 to go low, high, low corresponding to a 0,1 start bits

WAIT_LOW
	movf	TIME0_CNT,w
	btfsc	STATUS,Z	; timer overflow if zero
	goto	INPUT_SIG
	btfsc	GPIO,5		; wait till low 
	goto	WAIT_LOW
WAIT_HIGH
	movf	TIME0_CNT,w
	btfsc	STATUS,Z	; timer overflow if zero
	goto	INPUT_SIG
	btfss	GPIO,5		; wait for a high 
	goto	WAIT_HIGH
; start of 16ms reference period from transmitter
	bsf		T1CON,0		; timer1 on to count and check for overrange
WAIT_LOW1
	movf	TIME0_CNT,w
	btfsc	STATUS,Z	; timer overflow if zero
	goto	INPUT_SIG
	btfsc	GPIO,5		; wait till low
	goto	WAIT_LOW1
; read timer 1 and divide by 16 to get the required timer 1 offset (take from FFFF to get preload value)
; if outside range then ignore. Typically should be 1024 but 2048 to 512 allowable

	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	INPUT_SIG
	bcf		T1CON,0		; stop timer 1
	movf	TMR1L,w		; read timer 1
	movwf	TIMER1L_WK	; working registers
	movf	TMR1H,w
	movwf	TIMER1H_WK

; divide by 16 to get average count between each edge
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /2
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /4
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /8
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /16

; compare with over range/under range
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111110'		; 512 and greater
	btfsc	STATUS,Z		; if zero then value too small 
	goto	INPUT_SIG		; value off range
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111000'		; 2048 and greater
	btfss	STATUS,Z		; if not zero then value too large 
	goto	INPUT_SIG

; take from FFFF to get preset for interrupt rate	
	movf	TIMER1H_WK,w	; ms byte
	sublw	H'FF'			; maximum
	movwf	TIMER1H_VAL
	movf	TIMER1L_WK,w	; ls byte
	sublw	H'FF'			; maximum
	movwf	TIMER1L_VAL
	btfss	STATUS,C		; if carry reduce ms byte
	decf	TIMER1H_VAL,f

; add compensation for preload losses

	movlw	D'7'			; compensate for loss during preloading at interrupt
	addwf	TIMER1L_VAL,f	; add compensation
	btfsc	STATUS,C
	incf	TIMER1H_VAL,f	; if overrange increase ms byte

; preload counter 1 to sync with transmission rate 
	movf	TIMER1H_VAL,w
	movwf	TMR1H
	movf	TIMER1L_VAL,w
	movwf	TMR1L
	clrf	FLAG		; clear flag
	bsf		T1CON,0		; timer1 on start count	

	bsf		STATUS,RP0	; select memory bank 1		
	bsf		PIE1,TMR1IE	; timer 1 overflow interrupt restart
	bcf		STATUS,RP0	; select memory bank 0

; wait for one interrupt interval
WAIT_FLG_R
	btfss	FLAG,0
	goto	WAIT_FLG_R
	clrf	FLAG

; wait for 1/2 interrupt interval to centre measurement of level on high or low transmission

; calculate 1/2 interval
	bcf		STATUS,C	; carry cleared
	rrf		TIMER1H_WK,w; divide by 2
	movwf	TIMER1H_2	; place in secondary register
	rrf		TIMER1L_WK,w
	movwf	TIMER1L_2
	
; take from FFFF to get shift in time to read data centred on a 1 or 0 value
	bcf		INTCON,GIE	; stop interrupts
	bcf		T1CON,0		; stop timer 1

	movf	TIMER1H_2,w	; ms byte
	sublw	H'FF'		; maximum
	movwf	TMR1H
	movf	TIMER1L_2,w	; ls byte
	sublw	H'FF'		; maximum
	movwf	TMR1L
	btfss	STATUS,C	; if carry reduce ms byte
	decf	TMR1H,f

	bcf		PIR1,TMR1IF	; clear interrupt flag
	bsf		T1CON,0		; run timer 1
	clrf	FLAG
	bsf		INTCON,GIE	; allow interrupts

; start of data
; shift into RECEIVE

WAIT_FLG3
	btfss	FLAG,0		; wait for interrupt flag change
	goto	WAIT_FLG3

	clrf	FLAG		; clear interrupt flag
	bcf		STATUS,C	; clear carry 
	btfsc	GPIO,5		; check level
	bsf		STATUS,C	; set carry when GPIO,5 is set

	rlf		RECEIVEX,f	; stop bits value
	rlf		RECEIVE0,f	; exit or entry signal
	rlf		RECEIVE1,f	; encode
	decfsz	COUNT_BITS,f
	goto	WAIT_FLG3	; continue loading bits

; check stop bits

	movf	RECEIVEX,w	; check if stops bits are correct
	xorlw	D'142'		; stop bits code
	btfss	STATUS,Z	; if status is zero value is correct
	goto	INPUT_SIG 

; received identity (encode) must equal receiver encode
; find encode value from A/D

; identity
	bsf		ADCON0,2
	bsf		ADCON0,3	; ch3
	call	DELAYms		; wait
	call	ACQUIRE_AD
	movf	ADRESH,w
	andlw	B'11100000'	; use ms 3-digits for 8 selections
	movwf	ENCODE
	movf	RECEIVE1,w	; encoder
	xorwf	ENCODE,w
	btfss	STATUS,Z
	goto	INPUT_SIG

; check ENTRY or EXIT signal
	movf	RECEIVE0,w	; entry or exit received signal
	xorlw	H'33'		;  ENTRY signal
	btfsc  	STATUS,Z
	goto	DETECT		; entry signal
	movf	RECEIVE0,w	; entry or exit received signal
	xorlw	H'55'		;  EXIT signal
	btfsc  	STATUS,Z
	goto	DETECT		; exit signal
	movf	RECEIVE0,w	; entry or exit received signal
	xorlw	H'99'		; non-directional signal
	btfss  	STATUS,Z	; if equal exit signal
	goto	INPUT_SIG	; not equal so bypass

DETECT

	clrf	LED_ON		; interrupt delay counter value x 262ms
	bsf		STATUS,RP0	; select memory bank 1		
	bcf		PIE1,TMR1IE	; timer 1 overflow interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PIR1,TMR1IF	; timer 1 interrupt flag
	bcf		INTCON,T0IE	; timer 0 enable
	bcf		INTCON,T0IF	; timer 0 interrupt flag
	bcf		INTCON,PEIE	; enable periperal interrupts 	 
	bcf 	INTCON,GIE	; clear global interrupt enable 

; read duration at Ch2

	bcf		ADCON0,2
	bsf		ADCON0,3	; ch2
	call	DELAYms		; wait
	call	ACQUIRE_AD
	clrf	DURATION	; ms momentary counter
	
; divide by 16 for ~312mV resolution
	bcf		STATUS,C
	rrf		ADRESH,f
	bcf		STATUS,C
	rrf		ADRESH,f
	bcf		STATUS,C
	rrf		ADRESH,f
	bcf		STATUS,C
	rrf		ADRESH,f
	movf	ADRESH,w
	btfsc	STATUS,Z	; if 0 then use a 1	
	movlw	D'1'		; use a 1 if negative 
	movwf	DURATION	; alert duration

; check MODE
	btfsc	MODE,7		; if set then relay mode	
	goto	RELAY

; Piezo and LED mode
; clear existing LEDs

	bcf		GPIO,0
	bcf		GPIO,1

; sound alert and drive LED
	movf	RECEIVE0,w	; entry or exit received signal
	xorlw	H'33'		;  ENTRY signal
	btfsc  	STATUS,Z
	goto	SOUND_ENTRY
	movf	RECEIVE0,w	; entry or exit received signal
	xorlw	H'55'		;  EXIT signal
	btfsc  	STATUS,Z
	goto	SOUND_EXIT

	movf	RECEIVE0,w	; entry or exit received signal
	xorlw	H'99'		; ND, non-directional signal
	btfss  	STATUS,Z
	goto	INTERRUPT_SIG	; not equal so bypass

SOUND_ND ; non-directional

	bcf		GPIO,0			; exit LED off
	movlw	D'57'			; 229 = 60s
	movwf	LED_ON			; interrupt delay counter value x 262ms

; bip at start
	movlw	D'1'	
	movwf	BIPS_No			; bip length
	call	BIP				; horn bip

; modulate GPIO,1 for exit LED and sound
; drive transducer with fixed frequency

	movlw	D'188'		; 440 Hz
	movwf	SET1		; frequency setting value
	movlw	D'200'
	movwf	LENGTH
; drive tone over time
KEEP_FREQ
	call	FREQ_RUN_NO_DIR
	decfsz	LENGTH,f
	goto	KEEP_FREQ	; maintain frequency over time 
	bsf		FLASH,7		; set bit 7 for alternate LED flashing
	goto	INTERRUPT_SIG

SOUND_ENTRY
	bcf		GPIO,0			; exit LED cannot light
	movlw	D'57'			; 229 = 60s
	movwf	LED_ON			; interrupt delay counter value x 262ms

; bip at start
	movlw	D'1'	
	movwf	BIPS_No			; bip length
	call	BIP_EN			; horn bip

; modulate GPIO,1 for exit LED and sound
; sound falls in frequency over duration

; start with high frequency
	movlw	D'12'		; ~6.8kHz
	movwf	SET1		; frequency setting value

; decrease tone over time
FALL_FREQ
	call	FREQ_RUN_ENTRY
	incf	SET1,f
	btfss	STATUS,Z	; if zero, over 255 then end of tone generation
	goto	FALL_FREQ	; fall in frequency over time 

	bsf		GPIO,1			; ENTRY LED on till LED_ON interrupt counter is cleared
	goto	INTERRUPT_SIG

SOUND_EXIT

	bcf		GPIO,1			; entry LED cannot light
;
; keep EXIT LED on for period
	movlw	D'57'			; 229 = 60s
	movwf	LED_ON			; interrupt counter value x 262ms

; bip at start
	movlw	D'1'	
	movwf	BIPS_No			; bip length
	call	BIP_EX			; horn bip

; start with low frequency
	movlw	D'250'		; ~400Hz
	movwf	SET1		; frequency setting value

; increase tone over time
INC_FREQ
	call	FREQ_RUN_EXIT
	decf	SET1,f
	movlw	D'12'		; 6.8kHz
	subwf	SET1,w
	btfsc	STATUS,C	; if 12 then end of tone generation
	goto	INC_FREQ	; increase in frequency over time 

	bsf		GPIO,0			; EXIT LED on till LED_ON interrupt counter is cleared
	goto	INTERRUPT_SIG

RELAY

ON_RLY
; ON relay on
	movlw	D'5'
	movwf	EXTN		; delayy extension
	bsf		GPIO,0		; on relay switched on
	movlw	D'127'		; relay on period
	call	DELAYY0
	bcf		GPIO,0		; on relay off (similar to a finger press period
	movf	DURATION,w	; duration between ON and OFF relay (ie mains powered on duration)
MAINS_ON
; delay set by Duration (VR2)
	movlw	D'102'		; 102 for 5-minutes max (20s minimum as set with VR2)
	movwf	EXTN		; delayy extension
	movlw 	D'255'
	call	DELAYY0
	decfsz	DURATION,f	; decrease to 0
	goto	MAINS_ON
; OFF relay on
	movlw	D'5'
	movwf	EXTN		; delayy extension
	bsf		GPIO,1		; off relay switched on
	movlw	D'127'		; relay on period
	call	DELAYY0
	bcf		GPIO,1		; off relay off (similar to a finger press period

INTERRUPT_SIG	
; interrupts
	bsf		STATUS,RP0	; select memory bank 1		
	bsf		PIE1,TMR1IE	; timer 1 overflow interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PIR1,TMR1IF	; timer 1 interrupt flag
	bsf		INTCON,T0IE	; timer 0 enable
	bcf		INTCON,T0IF	; timer 0 interrupt flag
	bsf		INTCON,PEIE	; enable periperal interrupts 	 
	bsf 	INTCON,GIE	; set global interrupt enable 
	
	goto	INPUT_SIG


; ***************************************************************************	

; Subroutines

; generate tone

FREQ_RUN_NO_DIR; fixed tone 
	movf	DURATION,w		; length of tone set by VR2 
	movwf	TEMP
Hz0	btfss	TEMP,0
	goto	OTHER_LED
	bsf		GPIO,1			; light entry LED on and drive piezo
	movf	SET1,w
	call	FQ_DELAY1
	bcf		GPIO,1	
	decf	TEMP,w			; compensates for FALL_FREQ routine. Check if TEMP will be zero
	movlw	D'3'
	btfsc	STATUS,Z		; if zero compensate extra cycles
	movlw	D'5'
	subwf	SET1,w	

	call	FQ_DELAY1
	decfsz	TEMP,f
	goto	Hz0
	return
OTHER_LED
	bsf		GPIO,0			; light entry LED on and drive piezo
	movf	SET1,w
	call	FQ_DELAY1
	bcf		GPIO,0	
	decf	TEMP,w			; compensates for FALL_FREQ routine. Check if TEMP will be zero
	movlw	D'3'
	btfsc	STATUS,Z		; if zero compensate extra cycles
	movlw	D'5'
	subwf	SET1,w	

	call	FQ_DELAY1
	decfsz	TEMP,f
	goto	Hz0
	return

FREQ_RUN_ENTRY ; entry tone
	movf	DURATION,w	; length of tone set by VR2 
	movwf	TEMP
Hz
	bsf		GPIO,1			; light entry LED on and drive piezo
	movf	SET1,w
	call	FQ_DELAY1
	bcf		GPIO,1	
	decf	TEMP,w			; compensates for FALL_FREQ routine. Check if TEMP will be zero
	movlw	D'3'
	btfsc	STATUS,Z		; if zero compensate extra cycles
	movlw	D'5'
	subwf	SET1,w	

	call	FQ_DELAY1
	decfsz	TEMP,f
	goto	Hz
	return

FREQ_RUN_EXIT ; exit tone
	movf	DURATION,w	; length of tone set by VR2 
	movwf	TEMP
Hz1
	bsf		GPIO,0			; light exit LED on and drive piezo
	call	FQ_DELAY
	bcf		GPIO,0	

	decf	TEMP,w			; compensates for INC_FREQ routine. Check if TEMP will be zero
	movlw	D'3'
	btfsc	STATUS,Z		; if zero compensate extra cycles
	movlw	D'5'
	subwf	SET1,w	
	call	FQ_DELAY1

	decfsz	TEMP,f	
	goto	Hz1
	return

BIP
	movlw	D'188'		; ~440Hz
	movwf	SET1		; frequency setting value
	movlw	D'255'
	movwf	TEMP		; cycles
				
	call	Hz0			; bip

	decfsz	BIPS_No,f
	goto	BIP			; next bip
	call	EXTENDED_DELAY
	return

BIP_EN

	movlw	D'188'		; ~440Hz
	movwf	SET1		; frequency setting value
	movlw	D'255'
	movwf	TEMP		; cycles
				
	call	Hz			; bip

	decfsz	BIPS_No,f
	goto	BIP_EN		; next bip
	call	EXTENDED_DELAY
	return

BIP_EX

	movlw	D'188'		; ~440Hz
	movwf	SET1		; frequency setting value
	movlw	D'255'
	movwf	TEMP		; cycles
				
	call	Hz1			; bip

	decfsz	BIPS_No,f
	goto	BIP_EX		; next bip
	call	EXTENDED_DELAY
	return

; frequency delay; sets period of signal 
FQ_DELAY 
	movf	SET1,w
FQ_DELAY1
	movwf	FQ_FLAG
FQ_LOOP
	nop
	nop
	nop
	decfsz	FQ_FLAG,f	; decrease til zero
	goto	FQ_LOOP
	return

; delay loop 
EXTENDED_DELAY
	movlw	D'30'
	movwf	DEL_EXTN	; delay extension
EX_DLY
	call	DELAYms
	decfsz	DEL_EXTN,f
	goto	EX_DLY
	return
	
DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAYY0
	movwf	STORE1_STO
DELAYY
	movwf	STORE1		; STORE1 is number of loops value
LOOP10	
	movlw	H'FF'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP11
	decfsz	STORE2,f
	goto	LOOP11
	decfsz	STORE1,f
	goto	LOOP10
	decfsz	EXTN,f
	goto	EXTRA_DELAY
	return
EXTRA_DELAY
	movf	STORE1_STO,w
	goto	DELAYY
	

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return



	end
